; *************************************************************************************************
; * sega rom template 1.4
; *************************************************************************************************
; do not modify the start and end labels
; your code will be reconstructed when compiled in the correct place

#include	sega\s_main.mdl
#include	sega\s_math.mdl
#include	sega\s_input.mdl
#include	sega\s_dma.mdl
#include	sega\s_collision.mdl
#include	sega\s_saveram.mdl
#include	sega\s_z80.mdl

#segaromwavstart	458752	;wav files start originating
#memstart	16711680	;$ff0000

	org	512
segaromstart

	init_sega()	;get past sega security and clear ram
	init_segavdp()	;setup graphics and irq6 enabled also
	init_z80()		;setup dac

	init_collision()
; ******************************
; your code starts here
; ******************************



; setup 4 palettes red,green,blue   0-63 and color 0-7

	sega_palette(#1,#0,#0,#0)	;black	palette 0
	sega_palette(#2,#5,#5,#5)	;grey	text color on 2
	sega_palette(#3,#7,#7,#7)	;white
	sega_palette(#4,#0,#3,#0)	;dgreen
	sega_palette(#5,#0,#5,#0)	;green
	sega_palette(#6,#0,#7,#0)	;lgreen
	sega_palette(#7,#0,#0,#4)	;dblue
	sega_palette(#8,#0,#0,#7)	;blue
	sega_palette(#9,#4,#0,#0)	;dred
	sega_palette(#10,#7,#0,#0)	;red
	sega_palette(#11,#0,#4,#4)	;dcyan
	sega_palette(#12,#0,#7,#7)	;cyan
	sega_palette(#13,#7,#3,#7)	;purple
	sega_palette(#15,#7,#5,#2)	;dskin
	sega_palette(#14,#7,#7,#5)	;skin

	sega_palette(#17,#0,#0,#0)	;black	palette 1
	sega_palette(#18,#4,#4,#4)	;grey
	sega_palette(#19,#7,#7,#7)	;white
	sega_palette(#20,#0,#3,#0)	;dgreen
	sega_palette(#21,#0,#5,#0)	;green
	sega_palette(#22,#0,#7,#0)	;lgreen
	sega_palette(#23,#0,#0,#4)	;dblue
	sega_palette(#24,#0,#0,#7)	;blue
	sega_palette(#25,#4,#0,#0)	;dred
	sega_palette(#26,#7,#0,#0)	;red
	sega_palette(#27,#0,#4,#4)	;dcyan
	sega_palette(#28,#0,#7,#7)	;cyan
	sega_palette(#29,#7,#3,#7)	;purple
	sega_palette(#31,#7,#5,#2)	;dskin
	sega_palette(#30,#7,#7,#5)	;skin

	sega_palette(#33,#0,#0,#0)	;black	palette 2
	sega_palette(#34,#4,#4,#4)	;grey
	sega_palette(#35,#7,#7,#7)	;white
	sega_palette(#36,#0,#3,#0)	;dgreen
	sega_palette(#37,#0,#5,#0)	;green
	sega_palette(#38,#0,#7,#0)	;lgreen
	sega_palette(#39,#0,#0,#4)	;dblue
	sega_palette(#40,#0,#0,#7)	;blue
	sega_palette(#41,#4,#0,#0)	;dred
	sega_palette(#42,#7,#0,#0)	;red
	sega_palette(#43,#0,#4,#4)	;dcyan
	sega_palette(#44,#0,#7,#7)	;cyan
	sega_palette(#45,#7,#3,#7)	;purple
	sega_palette(#47,#7,#5,#2)	;dskin
	sega_palette(#46,#7,#7,#5)	;skin

	sega_palette(#49,#0,#0,#0)	;black	palette 3
	sega_palette(#50,#7,#0,#0)	;using for text color red,green,blue
	sega_palette(#51,#7,#7,#7)	;white
	sega_palette(#52,#0,#3,#0)	;dgreen
	sega_palette(#53,#0,#5,#0)	;green
	sega_palette(#54,#0,#7,#0)	;lgreen
	sega_palette(#55,#0,#0,#4)	;dblue
	sega_palette(#56,#0,#0,#7)	;blue
	sega_palette(#57,#4,#0,#0)	;dred
	sega_palette(#58,#7,#0,#0)	;red
	sega_palette(#59,#0,#4,#4)	;dcyan
	sega_palette(#60,#0,#7,#7)	;cyan
	sega_palette(#61,#7,#3,#7)	;purple
	sega_palette(#63,#7,#5,#2)	;dskin
	sega_palette(#62,#7,#7,#5)	;skin

	sega_font()	;setup diagnostic ascii (tiles 0-95) uses color #2 index


	sega_background(#0,#12)	;change background color


	sega_clearplanea(#0)
	sega_clearplaneb(#0)



	
	sega_loadtile(#120,#1,#smile)
	sega_setsprite(#0,#120,sprx,spry,#0,#0,#0,#0,#0,#0)


;make second sprite
	sega_setsprite(#1,#120,#280,#250,#0,#0,#0,#0,#0,#0)



	sega_linksprite(#0,#1)
	sega_linksprite(#1,#0)


	createsinetable(#sine_cosine)	;create cosine,sine table using a single byte
; 255 = 360 deg
; 128 = 180 deg etc...

	move.b	#0,angle
	move.w	#0,count

doloop
	move.w	count,d7
	beq	updateyes
	sub.w	#1,d7
	move.w	d7,count
	bra	noupdate

updateyes
	move.w	#0,d7
	move.w	d7,count
; adjust angle
	move.b	angle,d7
; treat it like a byte
	add.b	#1,d7

	move.b	d7,angle
; because its treated like a byte it will wrap 360 deg on its own


noupdate

	plotangle(sine_cosine,#260,#250,#30,#30,angle)	;table, posx,posy,diamx, diamy, angle 0-255 = 360 deg but takes word value
; that command returns position on d6,d7 as described in help

	move.w	d6,sprx
	move.w	d7,spry

; update the sprite
	sega_setsprite(#0,#120,sprx,spry,#0,#0,#0,#0,#0,#0)
	sega_linksprite(#0,#1)
	sega_linksprite(#1,#0)

;calc distance

	distance2d(#280,#250,sprx,spry)
	and.w	#255,d7
	move.w	d7,store
	wordstring(store,#mystring)

	sega_printa(#2,#1,#mystring2,#0,#0,#0,#0)

	sega_printa(#2,#2,#erase,#0,#0,#0,#0)
	sega_printa(#2,#2,#mystring,#0,#0,#0,#0)


; what angle
	pointangle(#280,#250,sprx,spry)
	lsl.w	#8,d7
	move.w	d7,store
	
	checkangle(store)
	move.w	d7,store

	wordstring(store,#mystring)
	
	sega_printa(#2,#3,#mystring3,#0,#0,#0,#0)

	sega_printa(#2,#4,#mystring,#0,#0,#0,#0)



	sync()
; code loop

	syncend()
	bra	doloop





def	store	word

def	sprx	word
def	spry	word
def	angle	string	2
def	sine_cosine	long

def	mystring	string	6
def	count	word
erase	dc.b	'     '
	even
	dc.b	0,0,0,0,0
	even

mystring2	dc.b	'Distance'
	dc.b	0,0
mystring3	dc.b	'Angle '
	dc.b	0,0
smile
	dc.l	$00000000
	dc.l	$0a0000a0
	dc.l	$00aaaa00
	dc.l	$000aa000
	dc.l	$000aa000
	dc.l	$00011000
	dc.l	$01111110
	dc.l	$00000000


; ******************************
; * end of program
; ******************************
ignore_handler
	rte	; return from exception
; included data goes here before compile automatically

segaromend

























